/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaDouble;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.function.LibFunction;
import org.squiddev.cobalt.function.RegisteredFunction;

public final class MathLib {
    private @Nullable RandomState random;

    private MathLib() {
    }

    public static void add(LuaState state) throws LuaError {
        MathLib self = new MathLib();
        RegisteredFunction[] registeredFunctionArray = new RegisteredFunction[28];
        registeredFunctionArray[0] = RegisteredFunction.of("abs", (s, arg) -> ValueFactory.valueOf(Math.abs(arg.checkDouble())));
        registeredFunctionArray[1] = RegisteredFunction.of("ceil", (s, arg) -> ValueFactory.valueOf(Math.ceil(arg.checkDouble())));
        registeredFunctionArray[2] = RegisteredFunction.of("cos", (s, arg) -> ValueFactory.valueOf(Math.cos(arg.checkDouble())));
        registeredFunctionArray[3] = RegisteredFunction.of("deg", (s, arg) -> ValueFactory.valueOf(Math.toDegrees(arg.checkDouble())));
        registeredFunctionArray[4] = RegisteredFunction.of("exp", (s, arg) -> ValueFactory.valueOf(Math.exp(arg.checkDouble())));
        registeredFunctionArray[5] = RegisteredFunction.of("floor", (s, arg) -> ValueFactory.valueOf(Math.floor(arg.checkDouble())));
        registeredFunctionArray[6] = RegisteredFunction.of("rad", (s, arg) -> ValueFactory.valueOf(Math.toRadians(arg.checkDouble())));
        registeredFunctionArray[7] = RegisteredFunction.of("sin", (s, arg) -> ValueFactory.valueOf(Math.sin(arg.checkDouble())));
        registeredFunctionArray[8] = RegisteredFunction.of("sqrt", (s, arg) -> ValueFactory.valueOf(Math.sqrt(arg.checkDouble())));
        registeredFunctionArray[9] = RegisteredFunction.of("tan", (s, arg) -> ValueFactory.valueOf(Math.tan(arg.checkDouble())));
        registeredFunctionArray[10] = RegisteredFunction.of("acos", (s, arg) -> ValueFactory.valueOf(Math.acos(arg.checkDouble())));
        registeredFunctionArray[11] = RegisteredFunction.of("asin", (s, arg) -> ValueFactory.valueOf(Math.asin(arg.checkDouble())));
        registeredFunctionArray[12] = RegisteredFunction.of("atan", MathLib::atan);
        registeredFunctionArray[13] = RegisteredFunction.of("cosh", (s, arg) -> ValueFactory.valueOf(Math.cosh(arg.checkDouble())));
        registeredFunctionArray[14] = RegisteredFunction.of("log10", (s, arg) -> ValueFactory.valueOf(Math.log10(arg.checkDouble())));
        registeredFunctionArray[15] = RegisteredFunction.of("sinh", (s, arg) -> ValueFactory.valueOf(Math.sinh(arg.checkDouble())));
        registeredFunctionArray[16] = RegisteredFunction.of("tanh", (s, arg) -> ValueFactory.valueOf(Math.tanh(arg.checkDouble())));
        registeredFunctionArray[17] = RegisteredFunction.of("fmod", MathLib::fmod);
        registeredFunctionArray[18] = RegisteredFunction.of("ldexp", MathLib::ldexp);
        registeredFunctionArray[19] = RegisteredFunction.of("pow", (s, x, y) -> ValueFactory.valueOf(Math.pow(x.checkDouble(), y.checkDouble())));
        registeredFunctionArray[20] = RegisteredFunction.of("atan2", (s, x, y) -> ValueFactory.valueOf(Math.atan2(x.checkDouble(), y.checkDouble())));
        registeredFunctionArray[21] = RegisteredFunction.of("log", MathLib::log);
        registeredFunctionArray[22] = RegisteredFunction.ofV("frexp", MathLib::frexp);
        registeredFunctionArray[23] = RegisteredFunction.ofV("max", MathLib::max);
        registeredFunctionArray[24] = RegisteredFunction.ofV("min", MathLib::min);
        registeredFunctionArray[25] = RegisteredFunction.ofV("modf", MathLib::modf);
        registeredFunctionArray[26] = RegisteredFunction.ofV("randomseed", self::randomseed);
        registeredFunctionArray[27] = RegisteredFunction.ofV("random", self::random);
        RegisteredFunction[] functions = registeredFunctionArray;
        LuaTable t = new LuaTable(0, functions.length + 3);
        RegisteredFunction.bind(t, functions);
        t.rawset("pi", (LuaValue)ValueFactory.valueOf(Math.PI));
        t.rawset("huge", (LuaValue)LuaDouble.POSINF);
        t.rawset("mod", t.rawget("fmod"));
        LibFunction.setGlobalLibrary(state, "math", t);
    }

    private static LuaValue fmod(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        double y;
        double x;
        double q = (x = arg1.checkDouble()) / (y = arg2.checkDouble());
        double f = x - y * (q >= 0.0 ? Math.floor(q) : Math.ceil(q));
        return ValueFactory.valueOf(f);
    }

    private static LuaValue ldexp(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        double x = arg1.checkDouble();
        double y = arg2.checkDouble() + 1023.5;
        long e = (long)(0 != (1 & (int)y) ? Math.floor(y) : Math.ceil(y - 1.0));
        return ValueFactory.valueOf(x * Double.longBitsToDouble(e << 52));
    }

    private static LuaValue log(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        if (arg2.isNil()) {
            return ValueFactory.valueOf(Math.log(arg1.checkDouble()));
        }
        return ValueFactory.valueOf(Math.log(arg1.checkDouble()) / Math.log(arg2.checkDouble()));
    }

    private static LuaValue atan(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        if (arg2.isNil()) {
            return ValueFactory.valueOf(Math.atan(arg1.checkDouble()));
        }
        return ValueFactory.valueOf(Math.atan2(arg1.checkDouble(), arg2.checkDouble()));
    }

    private static Varargs frexp(LuaState state, Varargs args) throws LuaError {
        double x = args.arg(1).checkDouble();
        if (x == 0.0) {
            return ValueFactory.varargsOf((LuaValue)Constants.ZERO, (Varargs)Constants.ZERO);
        }
        long bits = Double.doubleToLongBits(x);
        double m = (double)((bits & 0xFFFFFFFFFFFFFL) + 0x10000000000000L) * (bits >= 0L ? (double)1.110223E-16f : (double)-1.110223E-16f);
        double e = ((int)(bits >> 52) & 0x7FF) - 1022;
        return ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(m), (Varargs)ValueFactory.valueOf(e));
    }

    private static LuaValue max(LuaState state, Varargs args) throws LuaError {
        double m = args.arg(1).checkDouble();
        int n = args.count();
        for (int i = 2; i <= n; ++i) {
            m = Math.max(m, args.arg(i).checkDouble());
        }
        return ValueFactory.valueOf(m);
    }

    private static LuaValue min(LuaState state, Varargs args) throws LuaError {
        double m = args.arg(1).checkDouble();
        int n = args.count();
        for (int i = 2; i <= n; ++i) {
            m = Math.min(m, args.arg(i).checkDouble());
        }
        return ValueFactory.valueOf(m);
    }

    private static Varargs modf(LuaState state, Varargs args) throws LuaError {
        double x = args.arg(1).checkDouble();
        double intPart = x > 0.0 ? Math.floor(x) : Math.ceil(x);
        double fracPart = x - intPart;
        return ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(intPart), (Varargs)ValueFactory.valueOf(fracPart));
    }

    private RandomState getRandom() {
        return this.random != null ? this.random : (this.random = new RandomState());
    }

    private Varargs randomseed(LuaState state, Varargs args) throws LuaError {
        long part2;
        long part1;
        RandomState random = this.getRandom();
        if (args.count() == 0) {
            part1 = random.seeder.nextLong();
            part2 = random.seeder.nextLong();
        } else {
            part1 = args.arg(1).checkLong();
            part2 = args.arg(2).optLong(0L);
        }
        random.seed(part1, part2);
        return ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(part1), (Varargs)ValueFactory.valueOf(part2));
    }

    private LuaValue random(LuaState state, Varargs args) throws LuaError {
        if (this.random == null) {
            this.random = new RandomState();
        }
        switch (args.count()) {
            case 0: {
                return ValueFactory.valueOf(this.random.nextDouble());
            }
            case 1: {
                int high = args.arg(1).checkInteger();
                if (high < 1) {
                    throw ErrorFactory.argError(1, "interval is empty");
                }
                return ValueFactory.valueOf(1L + this.random.nextLong(high - 1));
            }
            case 2: {
                long low = args.arg(1).checkLong();
                long high = args.arg(2).checkLong();
                if (high < low) {
                    throw ErrorFactory.argError(2, "interval is empty");
                }
                return ValueFactory.valueOf(low + this.random.nextLong(high - low));
            }
        }
        throw new LuaError("wrong number of arguments");
    }

    private static class RandomState {
        private static final int FIGS = 53;
        private static final int SHIFT_FIGS = 11;
        private static final double SCALE_FIG = (double)1.110223E-16f;
        final Random seeder = new Random();
        private long state0;
        private long state1;
        private long state2;
        private long state3;

        RandomState() {
            this.seed(this.seeder.nextLong(), this.seeder.nextLong());
        }

        long nextLong() {
            long state0 = this.state0;
            long state1 = this.state1;
            long state2 = this.state2 ^ state0;
            long state3 = this.state3 ^ state1;
            long res = Long.rotateLeft(state1 * 5L, 7) * 9L;
            this.state0 = state0 ^ state3;
            this.state1 = state1 ^ state2;
            this.state2 = state2 ^ state1 << 17;
            this.state3 = Long.rotateLeft(state3, 45);
            return res;
        }

        long nextLong(long n) {
            long random = this.nextLong();
            if ((n & n + 1L) == 0L) {
                return random & n;
            }
            long lim = (1L << 64 - Long.numberOfLeadingZeros(n)) - 1L;
            assert ((lim & lim + 1L) == 0L);
            assert (lim > n && lim >> 1 < n);
            random &= lim;
            while (Long.compareUnsigned(random, n) > 0) {
                random = this.nextLong() & lim;
            }
            return random;
        }

        double nextDouble() {
            double value = (double)(this.nextLong() >> 11) * (double)1.110223E-16f;
            return value < 0.0 ? value + 1.0 : value;
        }

        void seed(long part1, long part2) {
            this.state0 = part1;
            this.state1 = 255L;
            this.state2 = part2;
            this.state3 = 0L;
            for (int i = 0; i < 16; ++i) {
                this.nextLong();
            }
        }
    }
}

